<?php
/**
 * @author Escriba aquí su nombre
 */

require_once "../../comunes/biblioteca.php";

session_name($cfg["sessionName"]);
session_start();

if (!isset($_SESSION["conectado"]) || $_SESSION["nivel"] < NIVEL_USUARIO_BASICO) {
    header("Location:../../index.php");
    exit;
}

$pdo = conectaDb();

cabecera("Categorías - Buscar 2", MENU_CATEGORIAS, PROFUNDIDAD_2);

$categoria = recoge("categoria");
$ordena    = recoge("ordena", default: "categoria ASC", allowed: $cfg["tablaCategoriasColumnasOrden"]);

$consulta = "SELECT * FROM $cfg[tablaCategorias]
             WHERE categoria LIKE :categoria
             ORDER BY $ordena";

$resultado = $pdo->prepare($consulta);
if (!$resultado) {
    print "    <p class=\"aviso\">Error al preparar la consulta. SQLSTATE[{$pdo->errorCode()}]: {$pdo->errorInfo()[2]}</p>\n";
} elseif (!$resultado->execute([":categoria" => "%$categoria%"])) {
    print "    <p class=\"aviso\">Error al ejecutar la consulta. SQLSTATE[{$pdo->errorCode()}]: {$pdo->errorInfo()[2]}</p>\n";
} elseif (count($registros = $resultado->fetchAll()) == 0) {
    print "    <p class=\"aviso\">No se han encontrado registros.</p>\n";
} else {
    print "    <form action=\"$_SERVER[PHP_SELF]\" method=\"$cfg[formMethod]\">\n";
    print "      <p>\n";
    print "        <input type=\"hidden\" name=\"categoria\" value=\"$categoria\">\n";
    print "      </p>\n";
    print "\n";
    print "      <p>Registros encontrados:</p>\n";
    print "\n";
    print "      <table class=\"conborde franjas\">\n";
    print "        <thead>\n";
    print "          <tr>\n";
    print "            <th>\n";
    print "              <button name=\"ordena\" value=\"categoria ASC\" class=\"boton-invisible\">\n";
    print "                <img src=\"../../img/abajo.svg\" alt=\"A-Z\" title=\"A-Z\" width=\"15\" height=\"12\">\n";
    print "              </button>\n";
    print "              Categoría\n";
    print "              <button name=\"ordena\" value=\"categoria DESC\" class=\"boton-invisible\">\n";
    print "                <img src=\"../../img/arriba.svg\" alt=\"Z-A\" title=\"Z-A\" width=\"15\" height=\"12\">\n";
    print "              </button>\n";
    print "            </th>\n";
    print "          </tr>\n";
    print "        </thead>\n";
    foreach ($registros as $registro) {
        print "        <tr>\n";
        print "          <td>$registro[categoria]</td>\n";
        print "        </tr>\n";
    }
    print "      </table>\n";
    print "    </form>\n";
}

pie();
