<?php
/**
 * @author Escriba aquí su nombre
 */

require_once "comunes/biblioteca.php";

session_name($cfg["sessionName"]);
session_start();

$pdo = conectaDb();

cabecera("Inicio", MENU_PRINCIPAL, PROFUNDIDAD_0);

$consulta = "SELECT
                noticias.id,
                categorias.categoria,
                noticias.titulo,
                noticias.cuerpo,
                noticias.creado
             FROM $cfg[tablaNoticias] as noticias
             JOIN $cfg[tablaCategorias] as categorias
             ON noticias.id_categoria = categorias.id
             ORDER BY creado DESC LIMIT $cfg[portadaNumeroNoticias]";

$resultado = $pdo->query($consulta);
if (!$resultado) {
    print "    <p class=\"aviso\">Error en la consulta. SQLSTATE[{$pdo->errorCode()}]: {$pdo->errorInfo()[2]}</p>\n";
} elseif (count($registros = $resultado->fetchAll()) == 0) {
    print "    <p class=\"aviso\">No se ha publicado todavía ninguna noticia.</p>\n";
} else {
    print "  <div class=\"noticias\">\n";
    foreach ($registros as $registro) {
        print "    <article class=\"noticia-portada\">\n";
        print "      <h2>$registro[titulo]</h2>\n";
        if ($registro["creado"] == "0000-00-00") {
            print "      <p class=\"noticia-categoria\">$registro[categoria]</p>\n";
        } else {
            print "      <p class=\"noticia-categoria\">$registro[categoria] ($registro[creado])</p>\n";
        }
        print "      <p class=\"noticia-cuerpo\">$registro[cuerpo]</p>\n";
        print "    </article>\n";
        print "\n";
    }
    print "  </div>\n";
}

pie();
